<?php

/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package acmfsap
 */

get_header();
?>

<main id="primary" class="site-main">

    <!-- -------------------------------------------------------------- --> <!-- -------------------------------------------------------------- -->
    <!-- Page wrapper  -->
    <!-- -------------------------------------------------------------- -->
    <div class="page-wrapper">
        <!-- -------------------------------------------------------------- -->
        <!-- Container fluid  -->
        <!-- -------------------------------------------------------------- -->
        <div class="container-fluid">
            <!-- ============================================================== -->
            <!-- Sales Summery -->
            <!-- ============================================================== -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-body">
                            <!-- title -->
                            <div class="d-md-flex align-items-center">
                                <div>
                                    <h4 class="card-title">Our Offices & ACMF Sponsored Schools</h4>
                                    <h5 class="card-subtitle">Map of the Caribbean</h5>
                                </div>
                            </div>
                            <!-- title -->
                            <div class="tab-content mt-4">
                                <iframe style="width: 100%; height: 450px;" src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d5441775.525878927!2d-77.58075882357093!3d19.594016599428027!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sjm!4v1679775339356!5m2!1sen!2sjm" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="schools" class="row">

                <!-- -------------
                    school
                ------------------>
                <div class="col-sm-12 col-lg-3 d-flex align-items-stretch">
                    <div class="card card-hover w-100">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-8 d-flex align-items-center">
                                    <div>
                                        <span>Kingston, Jamaica</span>
                                        <h4 class="mb-0">Caribbean Maritime University</h4>
                                    </div>
                                </div>
                                <div class="col-4 d-flex justify-content-end">
                                    <img alt="Caribbean Maritime University" src="http://localhost/wp-content/uploads/2023/02/cmu-logo.jpeg">
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-12">
                                    <h4>Sherine Wilson</h4>
                                    <ul class="box-list">
                                        <li><i class="fa fa-envelope"></i> info@acmf.org</li>
                                        <li><i class="fa fa-phone"></i> (876) 926 1590</li>
                                        <li><i class="fa fa-map-marker-alt"></i> 25 Dominica Drive, Kingston 5</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- -------------
                    school
                ------------------>
                <div class="col-sm-12 col-lg-3 d-flex align-items-stretch">
                    <div class="card card-hover w-100">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-8 d-flex align-items-center">
                                    <div>
                                        <span>Wallerfield, Trinidad</span>
                                        <h4 class="mb-0">The University of Trinidad and Tobago</h4>
                                    </div>
                                </div>
                                <div class="col-4 d-flex justify-content-end">
                                    <img alt="The University of Trinidad and Tobago" src="http://localhost/wp-content/uploads/2023/02/utt-logo.png">
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-12">
                                    <h4>Sherine Wilson</h4>
                                    <ul class="box-list">
                                        <li><i class="fa fa-envelope"></i> info@acmf.org</li>
                                        <li><i class="fa fa-phone"></i> (876) 926 1590</li>
                                        <li><i class="fa fa-map-marker-alt"></i> 25 Dominica Drive, Kingston 5</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- -------------
                    school
                ------------------>
                <div class="col-sm-12 col-lg-3 d-flex align-items-stretch">
                    <div class="card card-hover w-100">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-8 d-flex align-items-center">
                                    <div>
                                        <span>Nassau City, Bahamas</span>
                                        <h4 class="mb-0">LJM Maritime Academy</h4>
                                    </div>
                                </div>
                                <div class="col-4 d-flex justify-content-end">
                                    <img alt="LJM Maritime Academy" src="http://localhost/wp-content/uploads/2023/02/ljm-logo.png">
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-12">
                                    <h4>Sherine Wilson</h4>
                                    <ul class="box-list">
                                        <li><i class="fa fa-envelope"></i> info@acmf.org</li>
                                        <li><i class="fa fa-phone"></i> (876) 926 1590</li>
                                        <li><i class="fa fa-map-marker-alt"></i> 25 Dominica Drive, Kingston 5</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- -------------
                    school
                ------------------>
                <div class="col-sm-12 col-lg-3 d-flex align-items-stretch">
                    <div class="card card-hover w-100">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-8 d-flex align-items-center">
                                    <div>
                                        <span>Georgetown, Guyana</span>
                                        <h4 class="mb-0">MatPal Marine Institute</h4>
                                    </div>
                                </div>
                                <div class="col-4 d-flex justify-content-end">
                                    <img alt="MatPal Marine Institute" src="http://localhost/wp-content/uploads/2023/02/matpal-icon.png">
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-12">
                                    <h4>Sherine Wilson</h4>
                                    <ul class="box-list">
                                        <li><i class="fa fa-envelope"></i> info@acmf.org</li>
                                        <li><i class="fa fa-phone"></i> (876) 926 1590</li>
                                        <li><i class="fa fa-map-marker-alt"></i> 25 Dominica Drive, Kingston 5</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ============================================================== -->
            <!-- Trade history / Exchange -->
            <!-- ============================================================== -->
            <div class="row">
                <!-- column -->
                <div class="col-sm-12 col-lg-6">

                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Send us a message</h4>
                            <h5 class="card-subtitle mb-3 pb-3 border-bottom">Have any questions? Use the form below.</h5>
                            <form>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-floating mb-3">
                                            <input type="text" class="form-control" id="tb-fname" placeholder="Enter Name here">
                                            <label for="tb-fname">First Name</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating mb-3">
                                            <input type="text" class="form-control" id="tb-lname" placeholder="Enter Name here">
                                            <label for="tb-fname">Last Name</label>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-floating mb-3">
                                            <input type="text" class="form-control" id="tb-subject" placeholder="Subject">
                                            <label for="tb-email">Subject</label>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-floating mb-3">
                                            <textarea style="height: 200px;" class="form-control" id="tb-message" placeholder="Message"></textarea>
                                            <label for="tb-email">Message</label>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="d-md-flex align-items-center mt-3">

                                            <div class="ms-auto mt-3 mt-md-0">
                                                <button type="submit" class="btn btn-info font-medium rounded-pill px-4">
                                                    <div class="d-flex align-items-center">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-send feather-sm fill-white me-2">
                                                            <line x1="22" y1="2" x2="11" y2="13"></line>
                                                            <polygon points="22 2 15 22 11 13 2 9 22 2"></polygon>
                                                        </svg>
                                                        Submit
                                                    </div>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
                <!-- column -->
                <div class="col-sm-12 col-lg-6">
                    <div class="card">
                        <div class="card-body" style="height: 535px;">
                            <h4 class="card-title">Contact Us</h4>
                            <h5 class="card-subtitle mb-3 pb-3 border-bottom">Feel free to call, email or visit our offices.</h5>
                            <div class="tab-content mt-3" id="pills-tabContent3">
                                <p>Donec at justo vel purus imperdiet tempor. Vestibulum fringilla eros vel tortor rhoncus tempor. </p>
                                <div class="row">
                                    <div id="schools" class="col-12">
                                        <ul class="box-list">
                                            <li><i class="fa fa-envelope"></i> <b>Email:</b> info@acmf.org</li>
                                            <li><i class="fa fa-phone"></i> <b>Telephone:</b> (876) 926 1590</li>
                                            <li><i class="fa fa-map-marker-alt"></i><b> Address:</b> 25 Dominica Drive, Kingston 5</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- column -->
                <!-- column -->
            </div>
        </div>
    </div>
</main><!-- #main -->

<?php
get_footer();
