<?php

/**
 * acmfsap functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package acmfsap
 */

if (!defined('_S_VERSION')) {
	// Replace the version number of the theme on each release.
	define('_S_VERSION', '1.0.0');
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function acmfsap_setup()
{
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on acmfsap, use a find and replace
		* to change 'acmfsap' to the name of your theme in all the template files.
		*/
	load_theme_textdomain('acmfsap', get_template_directory() . '/languages');

	// Add default posts and comments RSS feed links to head.
	add_theme_support('automatic-feed-links');

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support('title-tag');

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support('post-thumbnails');

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__('Primary', 'acmfsap'),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'acmfsap_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action('after_setup_theme', 'acmfsap_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function acmfsap_content_width()
{
	$GLOBALS['content_width'] = apply_filters('acmfsap_content_width', 640);
}
add_action('after_setup_theme', 'acmfsap_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function acmfsap_widgets_init()
{
	register_sidebar(
		array(
			'name'          => esc_html__('Sidebar', 'acmfsap'),
			'id'            => 'sidebar-1',
			'description'   => esc_html__('Add widgets here.', 'acmfsap'),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action('widgets_init', 'acmfsap_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function acmfsap_scripts()
{
	wp_enqueue_style('acmfsap-style', get_stylesheet_uri(), array(), _S_VERSION);
	wp_style_add_data('acmfsap-style', 'rtl', 'replace');

	wp_enqueue_script('acmfsap-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true);

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}


	/*** source files ****/

	wp_enqueue_style('source-style', get_template_directory_uri()   . "/source/dist/css/style.min.css");

	wp_enqueue_style('source-fresh', get_template_directory_uri()   . "/css/fresh.css");

	wp_enqueue_script('html5shiv', 'https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js');
	wp_script_add_data('html5shiv', 'conditional', 'lt IE 9');

	wp_enqueue_script('respond', 'https://oss.maxcdn.com/respond/1.4.2/respond.min.js');
	wp_script_add_data('respond', 'conditional', 'lt IE 9');

	wp_enqueue_script('profile-scripts', get_template_directory_uri()  . "/source/assets/libs/jquery/dist/jquery.min.js", array(), false, true);
	wp_enqueue_script('profile-bootstrap', get_template_directory_uri()  . "/source/assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js", array(), false, true);
	wp_enqueue_script('profile-app', get_template_directory_uri()  . "/source/dist/js/app.min.js", array(), false, true);
	wp_enqueue_script('profile-horizontal', get_template_directory_uri()  . "/source/dist/js/app.init.horizontal.js", array(), false, true);
	wp_enqueue_script('profile-switcher', get_template_directory_uri()  . "/source/dist/js/app-style-switcher.js", array(), false, true);
	wp_enqueue_script('profile-scrollbar', get_template_directory_uri()  . "/source/assets/libs/perfect-scrollbar/dist/perfect-scrollbar.jquery.min.js", array(), false, true);
	wp_enqueue_script('profile-sparkline', get_template_directory_uri()  . "/source/assets/extra-libs/sparkline/sparkline.js", array(), false, true);
	wp_enqueue_script('profile-waves', get_template_directory_uri()  . "/source/dist/js/waves.js", array(), false, true);
	wp_enqueue_script('profile-sidebarmenu', get_template_directory_uri()  . "/source/dist/js/sidebarmenu.js", array(), false, true);
	wp_enqueue_script('profile-feather', get_template_directory_uri()  . "/source/dist/js/feather.min.js", array(), false, true);
	wp_enqueue_script('profile-custom', get_template_directory_uri()  . "/source/dist/js/custom.min.js", array(), false, true);


	if (is_singular('application')) {
		wp_enqueue_style('application-bootstrap', get_template_directory_uri()   . "/application/assets/bootstrap/css/bootstrap.min.css");
		wp_enqueue_style('application-owl.carousel', get_template_directory_uri()   . "/application/assets/css/owl.carousel.css");
		wp_enqueue_style('application-owl.theme', get_template_directory_uri()   . "/application/assets/css/owl.theme.css");
		wp_enqueue_style('application-font-awesome', get_template_directory_uri()   . "/application/assets/css/font-awesome.min.css");
		wp_enqueue_style('application-magnific-popup', get_template_directory_uri()   . "/application/assets/css/magnific-popup.css");
		wp_enqueue_style('application-style', get_template_directory_uri()   . "/application/assets/css/style.css");

		// wp_enqueue_script('application-jquery', get_template_directory_uri()  . "/application/assets/js/jquery-1.12.3.min.js", array(), false, true);
		wp_enqueue_script('application-onepage', get_template_directory_uri()  . "/application/assets/js/jquery.onepage-scroll.min.js", array(), false, true);
		wp_enqueue_script('application-easing', get_template_directory_uri()  . "/application/assets/js/jquery.easing.min.js", array(), false, true);
		wp_enqueue_script('application-backstretch', get_template_directory_uri()  . "/application/assets/js/jquery.backstretch.min.js", array(), false, true);
		wp_enqueue_script('application-filterizr', get_template_directory_uri()  . "/application/assets/js/jquery.filterizr.js", array(), false, true);
		wp_enqueue_script('application-magnific', get_template_directory_uri()  . "/application/assets/js/jquery.magnific-popup.min.js", array(), false, true);
		wp_enqueue_script('application-bootstrap', get_template_directory_uri()  . "/application/assets/bootstrap/js/bootstrap.min.js", array(), false, true);
		wp_enqueue_script('application-owl-carousel', get_template_directory_uri()  . "/application/assets/js/owl.carousel.min.js", array(), false, true);
		wp_enqueue_script('application-custom', get_template_directory_uri()  . "/application/assets/js/custom.js", array(), false, true);
		wp_enqueue_script('application-smoothscroll', get_template_directory_uri()  . "/application/assets/js/smoothscroll.min.js", array(), false, true);
	}
}
add_action('wp_enqueue_scripts', 'acmfsap_scripts');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require get_template_directory() . '/inc/jetpack.php';
}

/////////////////////////////////// custom ///////////////////////////////////
include_once(ABSPATH . 'wp-admin/includes/plugin.php');

if (file_exists(dirname(__FILE__) . '/elementor-widgets/elementor-widgets.php') && is_plugin_active('elementor/elementor.php')) {
	require_once(dirname(__FILE__) . '/elementor-widgets/elementor-widgets.php');
}

if (!class_exists('ReduxFramework') && file_exists(dirname(__FILE__) . '/admin/ReduxCore/framework.php')) {
	require_once(dirname(__FILE__) . '/admin/ReduxCore/framework.php');
}
if (!isset($redux_demo) && file_exists(dirname(__FILE__) . '/admin/options-init.php')) {
	require_once(dirname(__FILE__) . '/admin/options-init.php');
}


add_action('cmb2_admin_init', 'acmfsap_register_home_metabox');
function acmfsap_register_home_metabox()
{
	$prefix = '_acmfsap_';
	$cmb2_home = new_cmb2_box(array(
		'id' => $prefix . 'home_metabox',
		'title' => __('Home Page Details', 'cmb2'),
		'object_types' => array(
			'home', 'page',
		),
		'show_on' => array('id' => 20),
		'context' => 'normal',
		'priority' => 'high',
		'show_names' => true,
	));


	// $cmb2_home->add_field(array(
	// 	'name'             => 'Primary Section Main Title',
	// 	'id'               => $prefix . 'primary_section_main_title',
	// 	'type'             => 'text',

	// ));
	// $cmb2_home->add_field(array(
	// 	'name'             => 'Primary Section Sub Title',
	// 	'id'               => $prefix . 'primary_section_sub_title',
	// 	'type'             => 'text',

	// ));

	// $cmb2_home->add_field(array(
	// 	'name' => __('Primary Section Image', 'cmb2'),
	// 	'id' => $prefix . 'primary_section_image',
	// 	'type' => 'file',
	// 	// Optional:
	// 	'options' => array(
	// 		'url' => true, // Hide the text input for the url
	// 	),
	// 	'query_args' => array(
	// 		'type' => array(
	// 			'jpeg',
	// 			'png',
	// 		),
	// 	)
	// ));

	$cmb2_home->add_field(array(
		'name'             => 'Secondary Section Main Title',
		'id'               => $prefix . 'secondary_section_main_title',
		'type'             => 'text',

	));
	$cmb2_home->add_field(array(
		'name'             => 'Secondary Section Sub Title',
		'id'               => $prefix . 'secondary_section_sub_title',
		'type'             => 'text',

	));
	$cmb2_home->add_field(array(
		'name'             => 'Secondary Section Description',
		'id'               => $prefix . 'secondary_section_desc',
		'type'             => 'wysiwyg',
	));


	$cmb2_home->add_field(array(
		'name'             => 'Button Icon 1',
		'id'               => $prefix . 'home_button_icon_1',
		'type'             => 'text',
	));

	$cmb2_home->add_field(array(
		'name'             => 'Button Sub Title 1',
		'id'               => $prefix . 'home_button_sub_title_1',
		'type'             => 'text',
	));

	$cmb2_home->add_field(array(
		'name'             => 'Button Main Title 1',
		'id'               => $prefix . 'home_button_main_title_1',
		'type'             => 'text',
	));

	$cmb2_home->add_field(array(
		'name'             => 'Button Link 1',
		'id'               => $prefix . 'home_button_link_1',
		'type'             => 'text',
	));

	$cmb2_home->add_field(array(
		'name'             => 'Button Icon 1',
		'id'               => $prefix . 'home_button_icon_2',
		'type'             => 'text',
	));

	$cmb2_home->add_field(array(
		'name'             => 'Button Sub Title 1',
		'id'               => $prefix . 'home_button_sub_title_2',
		'type'             => 'text',
	));

	$cmb2_home->add_field(array(
		'name'             => 'Button Main Title 1',
		'id'               => $prefix . 'home_button_main_title_2',
		'type'             => 'text',
	));

	$cmb2_home->add_field(array(
		'name'             => 'Button Link 1',
		'id'               => $prefix . 'home_button_link_2',
		'type'             => 'text',
	));


	// Repeatable group
	$group_home_school = $cmb2_home->add_field(array(
		'id'          => $prefix . 'home_school',
		'type'        => 'group',
		'options'     => array(
			'group_title'   => __('School #', 'cmb2') . '{#}', // {#} gets replaced by row number
			'add_button'    => __('Add another school', 'cmb2'),
			'remove_button' => __('Remove school', 'cmb2'),
			'sortable'      => true, // beta
		),
	));
	//* Title
	$cmb2_home->add_group_field($group_home_school, array(
		'name'    => __('School Name', 'cmb2'),
		'id'      => $prefix . 'home_school_name',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb2_home->add_group_field($group_home_school, array(
		'name'    => __('School Location', 'cmb2'),
		'id'      => $prefix . 'home_school_location',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb2_home->add_group_field($group_home_school, array(
		'name' => __('School Logo', 'cmb2'),
		'id' => $prefix . 'home_school_logo',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'gif',
				'jpeg',
				'png',
			),
		)
	));
}



function acmfjb_register_application_details_metabox()
{

	$prefix = '_acmfjb_';

	$cmb_application_details = new_cmb2_box(array(
		'id'            => $prefix . 'application_details_metabox',
		'title'         => __('Application Details', 'cmb2'),
		'object_types' => array('application'), // post type
		'context'       => 'normal',
		'priority'      => 'high',
		'show_names'    => true,
	));



	//SECTION A – PERSONAL/CONTACT INFORMATION
	$cmb_application_details->add_field(array(
		'name' => 'SECTION A – PERSONAL/CONTACT INFORMATION',
		'desc' => 'Please add the requested personal/contact information',
		'type' => 'title',
		'id'   => 'section_a'
	));

	$cmb_application_details->add_field(array(
		'name'             => 'First Name',
		'id'               => $prefix . 'application_first_name',
		'type'             => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name'             => 'Middle Name',
		'id'               => $prefix . 'application_middle_name',
		'type'             => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name'             => 'Last Name',
		'id'               => $prefix . 'application_last_name',
		'type'             => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Sex',
		'id'               => $prefix . 'application_sex',
		'type'             => 'select',
		'options'          => array(
			'Male' => __('Male', 'cmb2'),
			'Female' => __('Female', 'cmb2'),
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Age',
		'id'               => $prefix . 'application_age',
		'type'             => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Are you an international student?',
		'id'               => $prefix . 'application_international_student',
		'type'             => 'radio_inline',
		'options'          => array(
			'Yes' => __('Yes', 'cmb2'),
			'No' => __('No', 'cmb2'),
		),
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name' => 'Date of Birth',
		'id'   => $prefix . 'application_dob',
		'type' => 'text_date_timestamp',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Parish', 'cmb2'),
		'id'      => $prefix . 'application_parish',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Home Number', 'cmb2'),
		'id'      => $prefix . 'application_home_no',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name'    => __('Cell Number:', 'cmb2'),
		'id'      => $prefix . 'application_cell_no',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Email', 'cmb2'),
		'id'      => $prefix . 'application_email',
		'type'    => 'text_email',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));


	$cmb_application_details->add_field(array(
		'name'    => __('Address', 'cmb2'),
		'id'      => $prefix . 'application_address',
		'type'    => 'textarea',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Mailing Address (If Different from above)', 'cmb2'),
		'id'      => $prefix . 'application_mailing_address',
		'type'    => 'textarea',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Taxpayer Registration Number (TRN)', 'cmb2'),
		'id'      => $prefix . 'application_trn',
		'desc'    => 'For Jamaican nationals: Taxpayer Registration Number (TRN)',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));


	//SECTION B – DETAILS OF PROGRAM
	$cmb_application_details->add_field(array(
		'name' => 'SECTION B – PROGRAM DETAILS',
		'desc' => 'Please add the relevant details about your program/course',
		'type' => 'title',
		'id'   => 'section_b'
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Faculty', 'cmb2'),
		'id'      => $prefix . 'application_faculty',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'College Year',
		'id'               => $prefix . 'application_college_year',
		'type'             => 'select',
		'options'          => array(
			'freshman' => __('Freshman', 'cmb2'),
			'sophomore' => __('Sophomore', 'cmb2'),
			'junior' => __('Junior', 'cmb2'),
			'senior' => __('Senior', 'cmb2'),
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Have you previously been awarded any scholarships?',
		'id'               => $prefix . 'application_previous_scholarships',
		'desc' 			   => 'or bursary etc., in connection to your present course of study',
		'type'             => 'radio_inline',
		'options'          => array(
			'Yes' => __('Yes', 'cmb2'),
			'No' => __('No', 'cmb2'),
		),
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));


	$cmb_application_details->add_field(array(
		'name'    => __('If so please, supply any details', 'cmb2'),
		'id'      => $prefix . 'application_previous_scholarships_details',
		'type'    => 'textarea',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'How do you afford your university expenses?',
		'id'               => $prefix . 'application_university_expenses',
		'type'             => 'select',
		'options'          => array(
			'student_loan' => __('Student Loan', 'cmb2'),
			'boarding' => __('Grant Boarding Grant', 'cmb2'),
			'parental' => __('Support Parental Support', 'cmb2'),
			'employed' => __('Employed', 'cmb2'),
			'other' => __('Other', 'cmb2'),

		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Please explain (include how much you receive each term; duration of support, etc. ', 'cmb2'),
		'id'      => $prefix . 'application_university_expenses_details',
		'type'    => 'textarea',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name' => '',
		'desc' => 'If you are currently employed please fill out the following information',
		'type' => 'title',
		'id'   => 'section_employer'
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Employer Name ', 'cmb2'),
		'id'      => $prefix . 'application_company_name',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name'    => __('If you are currently employed', 'cmb2'),
		'id'      => $prefix . 'application_company_years',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name'    => __('Position', 'cmb2'),
		'id'      => $prefix . 'application_company_position',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name'    => __('Start Date', 'cmb2'),
		'id'      => $prefix . 'application_start_date',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name'    => __('End Date', 'cmb2'),
		'id'      => $prefix . 'application_company_end_date',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Number of hours per week that you work', 'cmb2'),
		'id'      => $prefix . 'application_company_hours',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	//SECTION C — YOUR EDUCATION (INCLUDING TRAINING COURSES)
	$cmb_application_details->add_field(array(
		'name' => 'SECTION C — YOUR EDUCATION (INCLUDING TRAINING COURSES)',
		'desc' => 'Please give details of your undergraduate qualifications including Honors and attach copies of Transcripts giving
			subject details and results. Eligible applicants must have a minimum of a cumulative GPA of 3.0.',
		'type' => 'title',
		'id'   => 'section_c'
	));


	$group_application_qualification = $cmb_application_details->add_field(array(
		'id'          => $prefix . 'application_qualification',
		'type'        => 'group',
		'options'     => array(
			'group_title'   => __('Qualification #', 'cmb2') . '{#}', // {#} gets replaced by row number
			'add_button'    => __('Add another qualification', 'cmb2'),
			'remove_button' => __('Remove qualification', 'cmb2'),
			'sortable'      => true, // beta
		),
	));


	$cmb_application_details->add_group_field($group_application_qualification, array(
		'name'    => __('Name', 'cmb2'),
		'id'      => $prefix . 'application_qualification_name',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_group_field($group_application_qualification, array(
		'name'    => __('Level of Honors Obtained', 'cmb2'),
		'id'      => $prefix . 'application_qualification_honors',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_group_field($group_application_qualification, array(
		'name'    => __('Institution/University & Location', 'cmb2'),
		'desc'    => __('City, Parish/State & Country', 'cmb2'),
		'id'      => $prefix . 'application_school_location',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_group_field($group_application_qualification, array(
		'name'    => __('Duration of Study', 'cmb2'),
		'id'      => $prefix . 'application_qualification_duration',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_group_field($group_application_qualification, array(
		'name'    => __('Have you completed your course/program?', 'cmb2'),
		'id'      => $prefix . 'application_school_completed',
		'type'             => 'radio_inline',
		'options'          => array(
			'Yes' => __('Yes', 'cmb2'),
			'No' => __('No', 'cmb2'),
		),
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	//SECTION D — EXTRACURRICULAR ACTIVITIES (Leadership & Volunteerism)
	$cmb_application_details->add_field(array(
		'name' => 'SECTION D — EXTRACURRICULAR ACTIVITIES',
		'desc' => 'Please give details of your extracurricular activities including and leadership postions and volunteerism.',
		'type' => 'title',
		'id'   => 'section_d'
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Leadership Positions', 'cmb2'),
		'desc'    => __('List any leadership positions or offices held during your educational/or professional career', 'cmb2'),
		'id'      => $prefix . 'application_leadership_positions',
		'type'    => 'textarea',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Clubs/Societies Membership', 'cmb2'),
		'desc'    => __('List any leadership positions or offices held during your educational/or professional career', 'cmb2'),
		'id'      => $prefix . 'application_clubs_societies',
		'type'    => 'textarea',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Have you participated in community/voluntary service?',
		'id'               => $prefix . 'application_community_service',
		'type'             => 'radio_inline',
		'options'          => array(
			"No" => __("No", 'cmb2'),
			'Yes' => __('Yes', 'cmb2'),
		),
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Community Service Details', 'cmb2'),
		'desc'    => __('If yes, what kind of assistance did you provide and when?', 'cmb2'),
		'id'      => $prefix . 'application_community_service_details',
		'type'    => 'textarea',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_field(array(
		'name' => 'Date of Community Service',
		'desc'    => __('When did you provide this service?', 'cmb2'),
		'id'   => $prefix . 'application_community_service_date',
		'type' => 'text_date_timestamp',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	//SECTION E — FAMILY INFORMATION
	$cmb_application_details->add_field(array(
		'name' => 'SECTION E — FAMILY INFORMATION',
		'desc' => 'Please fill out the inforamation requested about your family',
		'type' => 'title',
		'id'   => 'section_e'
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Are you a parent?',
		'id'               => $prefix . 'application_parent',
		'type'             => 'radio_inline',
		'options'          => array(
			"No" => __("No", 'cmb2'),
			'Yes' => __('Yes', 'cmb2'),
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Are you a custodial parent?',
		'id'               => $prefix . 'application_custodial_parent',
		'type'             => 'radio_inline',
		'options'          => array(
			"No" => __("No", 'cmb2'),
			'Yes' => __('Yes', 'cmb2'),
		),
	));

	$cmb_application_details->add_field(array(
		'name'             => 'Does your child(ren) live with you?',
		'id'               => $prefix . 'application_children',
		'type'             => 'radio_inline',
		'options'          => array(
			"No" => __("No", 'cmb2'),
			'Yes' => __('Yes', 'cmb2'),
		),
	));



	//SECTION F — REFFERENCES
	$cmb_application_details->add_field(array(
		'name' => 'SECTION F — REFFERENCES',
		'desc' => 'Please add the requested inforamation about your references',
		'type' => 'title',
		'id'   => 'section_f'
	));

	$group_application_reference = $cmb_application_details->add_field(array(
		'id'          => $prefix . 'application_reference',
		'type'        => 'group',
		'options'     => array(
			'group_title'   => __('Reference #', 'cmb2') . '{#}', // {#} gets replaced by row number
			'add_button'    => __('Add another reference ', 'cmb2'),
			'remove_button' => __('Remove reference', 'cmb2'),
			'sortable'      => true, // beta
		),
	));

	$cmb_application_details->add_group_field($group_application_reference, array(
		'name'    => __('Name', 'cmb2'),
		'id'      => $prefix . 'application_reference_name',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_group_field($group_application_reference, array(
		'name'    => __('Position', 'cmb2'),
		'id'      => $prefix . 'application_reference_position',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	$cmb_application_details->add_group_field($group_application_reference, array(
		'name'    => __('Institution', 'cmb2'),
		'id'      => $prefix . 'application_reference_institution',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_group_field($group_application_reference, array(
		'name'    => __('Tel', 'cmb2'),
		'id'      => $prefix . 'application_reference_tel',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));
	$cmb_application_details->add_group_field($group_application_reference, array(
		'name'    => __('Email', 'cmb2'),
		'id'      => $prefix . 'application_reference_email',
		'type'    => 'text',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	//SECTION G — NARRATIVE
	$cmb_application_details->add_field(array(
		'name' => 'SECTION G — NARRATIVE',
		'desc' => 'Please write an essay detailing why are you would be a good candidate for this scholarship and what are your future goals? (250 words)',
		'type' => 'title',
		'id'   => 'section_G'
	));

	$cmb_application_details->add_field(array(
		'name'    => __('Essay', 'cmb2'),
		'id'      => $prefix . 'application_essay',
		'type'    => 'wysiwyg',
		'attributes'  =>  array(
			'required'  =>  'required',
		),
	));

	//SECTION H — ATTACHMENTS
	$cmb_application_details->add_field(array(
		'name' => 'SECTION H — ATTACHMENTS',
		'desc' => 'Please upload the follwing documents to complete your application.',
		'type' => 'title',
		'id'   => 'section_h'
	));

	$cmb_application_details->add_field(array(
		'name' => __('Academic Transcript', 'cmb2'),
		'desc' =>  __('ONE copy of your official Academic Transcript (certified copy may be required later in the process)', 'cmb2'),
		'id' => $prefix . 'application_transcript',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'pdf',
				'doc',
				'docx',
				'gif',
				'jpeg',
				'png',
			),
		)
	));
	$cmb_application_details->add_field(array(
		'name' => __('Resume', 'cmb2'),
		'desc' =>  __('ONE copy of your Resume', 'cmb2'),
		'id' => $prefix . 'application_resume',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'pdf',
				'doc',
				'docx',
				'gif',
				'jpeg',
				'png',
			),
		)
	));
	$cmb_application_details->add_field(array(
		'name' => __('Letters of recommendation', 'cmb2'),
		'desc' =>  __('TWO (2) Letters of Reference, other than family members, displaying a stamp or letterhead', 'cmb2'),
		'id' => $prefix . 'application_recommendation',
		'type' => 'file_list',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'pdf',
				'doc',
				'docx',
				'gif',
				'jpeg',
				'png',
			),
		)
	));
	$cmb_application_details->add_field(array(
		'name' => __('Birth certificate', 'cmb2'),
		'desc' =>  __('Copy of birth certificate', 'cmb2'),
		'id' => $prefix . 'application_birth_certificate',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'pdf',
				'doc',
				'docx',
				'gif',
				'jpeg',
				'png',
			),
		)
	));
	$cmb_application_details->add_field(array(
		'name' => __('Photo', 'cmb2'),
		'desc' =>  __('Passport size photo', 'cmb2'),
		'id' => $prefix . 'application_photo',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'jpeg',
				'png',
			),
		)
	));
	$cmb_application_details->add_field(array(
		'name' => __('Educational qualifications', 'cmb2'),
		'desc' =>  __('Educational qualifications (CSEC/GCE/CAPE results, professional certification and/or equivalent qualification)
(Not required for currently enrolled CMU students)', 'cmb2'),
		'id' => $prefix . 'application_edu_qualifications',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'pdf',
				'doc',
				'docx',
				'gif',
				'jpeg',
				'png',
			),
		)
	));
	$cmb_application_details->add_field(array(
		'name' => __('Police of criminal record', 'cmb2'),
		'desc' =>  __('Certification from the Police of criminal record (applicants for the Faculty of Marine and Nautical Studies)', 'cmb2'),
		'id' => $prefix . 'application_criminal_record',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'pdf',
				'doc',
				'docx',
				'gif',
				'jpeg',
				'png',
			),
		)
	));
	$cmb_application_details->add_field(array(
		'name' => __('Valid passport', 'cmb2'),
		'desc' =>  __('Valid passport (overseas nationals and applicants for the Faculty of Marine and Nautical Studies)', 'cmb2'),
		'id' => $prefix . 'application_passport',
		'type' => 'file',
		// Optional:
		'options' => array(
			'url' => true, // Hide the text input for the url
		),
		'query_args' => array(
			'type' => array(
				'pdf',
				'doc',
				'docx',
				'gif',
				'jpeg',
				'png',
			),
		)
	));
}

add_action('cmb2_init', 'acmfjb_register_application_details_metabox');
