<?php

/**
 * For full documentation, please visit: http://docs.reduxframework.com/
 * For a more extensive sample-config file, you may look at:
 * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
 */

if (!class_exists('Redux')) {
    return;
}

// This is your option name where all the Redux data is stored.
$opt_name = "redux_acmfsap";

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    'opt_name' => 'redux_acmfsap',
    'page_slug' => 'acmfsap_theme_options',
    'page_title' => 'ACMF SAP Theme Options',
    'update_notice' => TRUE,
    'admin_bar' => TRUE,
    'menu_type' => 'menu',
    'menu_title' => 'ACMF SAP Theme Options',
    'allow_sub_menu' => TRUE,
    'page_parent_post_type' => 'your_post_type',
    'customizer' => TRUE,
    'default_mark' => '*',
    'hints' => array(
        'icon_position' => 'right',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'light',
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect' => array(
            'show' => array(
                'duration' => '500',
                'event' => 'mouseover',
            ),
            'hide' => array(
                'duration' => '500',
                'event' => 'mouseleave unfocus',
            ),
        ),
    ),
    'output' => TRUE,
    'output_tag' => TRUE,
    'settings_api' => TRUE,
    'cdn_check_time' => '1440',
    'compiler' => TRUE,
    'page_permissions' => 'manage_options',
    'save_defaults' => TRUE,
    'show_import_export' => TRUE,
    'database' => 'options',
    'transient_time' => '3600',
    'network_sites' => TRUE,
    'use_cdn' => TRUE,
);

// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
$args['share_icons'][] = array(
    'url'   => 'https://jis.gov.jm/',
    'title' => 'Visit our Website',
    'icon'  => 'el el-globe'
    //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
);
$args['share_icons'][] = array(
    'url'   => 'https://www.facebook.com/JISVoice/',
    'title' => 'Like us on Facebook',
    'icon'  => 'el el-facebook'
);
$args['share_icons'][] = array(
    'url'   => 'https://twitter.com/JISNews',
    'title' => 'Follow us on Twitter',
    'icon'  => 'el el-twitter'
);
$args['share_icons'][] = array(
    'url'   => 'https://www.instagram.com/jisvoice/',
    'title' => 'Find us on Instagram',
    'icon'  => 'el el-instagram'
);

Redux::setArgs($opt_name, $args);

/*
     * ---> END ARGUMENTS
     */

/*
     * ---> START HELP TABS
     */

$tabs = array(
    array(
        'id'      => 'redux-help-tab-1',
        'title'   => __('Theme Information 1', 'admin_folder'),
        'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'admin_folder')
    ),
    array(
        'id'      => 'redux-help-tab-2',
        'title'   => __('Theme Information 2', 'admin_folder'),
        'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'admin_folder')
    )
);
Redux::setHelpTab($opt_name, $tabs);

// Set the help sidebar
$content = __('<p>This is the sidebar content, HTML is allowed.</p>', 'admin_folder');
Redux::setHelpSidebar($opt_name, $content);


/*
     * <--- END HELP TABS
     */


/*
     *
     * ---> START SECTIONS
     *
     */

Redux::setSection($opt_name, array(
    'title'  => __('Header', 'acmfsap'),
    'id'     => 'header-section',
    'icon'   => 'el el-home',
    'fields'     => array(
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => __('Upload Favicon', 'acmfsap'),
        ),
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => __('Upload Logo', 'acmfsap'),
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => __('Header Site Name', 'acmfsap'),
    'id'         => 'header-site-name-section',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'header-site-name-row-1',
            'type'     => 'text',
            'title'    => __('Header Site Name (Row 1)', 'acmfsap'),
        ),
        array(
            'id'       => 'header-site-name-row-2',
            'type'     => 'text',
            'title'    => __('Header Site Name (Row 2)', 'acmfsap'),
        ),
        array(
            'id'       => 'header-site-name-row-3',
            'type'     => 'text',
            'title'    => __('Header Site Name (Row 3)', 'acmfsap'),
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => __('Header Background', 'acmfsap'),
    'id'         => 'header-bgrd-section',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'header-bgrd-image',
            'type'     => 'media',
            'title'    => __('Header Background Image', 'acmfsap'),
            'default'  => array(
                'url' => ''
            ),
        ),
        array(
            'id'       => 'header-bgrd-position',
            'type'     => 'select',
            'title'    => __('Header Background Position', 'acmfsap'),
            'options'  => array(
                'top'     => 'top',
                'center' => 'center',
                'bottom' => 'bottom',
            ),
            'default'  => 'top',
        ),

    ),
));

Redux::setSection($opt_name, array(
    'title'      => __('Header Slider', 'acmfsap'),
    'id'         => 'header-slider-section',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'header-slider-image-1',
            'type'     => 'media',
            'title'    => __('Header Slider Image 1', 'acmfsap'),
            'default'  => array(
                'url' => ''
            ),
        ),
        array(
            'id'       => 'header-slider-image-2',
            'type'     => 'media',
            'title'    => __('Header Slider Image 2', 'acmfsap'),
            'default'  => array(
                'url' => ''
            ),
        ),
        array(
            'id'       => 'header-slider-image-3',
            'type'     => 'media',
            'title'    => __('Header Slider Image 3', 'acmfsap'),
            'default'  => array(
                'url' => ''
            ),
        ),
        array(
            'id'       => 'header-slider-position',
            'type'     => 'select',
            'title'    => __('Header Slider Position', 'acmfsap'),
            'options'  => array(
                'top'     => 'top',
                'center' => 'center',
                'bottom' => 'bottom',
            ),
            'default'  => 'top',
        ),

    ),
));
Redux::setSection($opt_name, array(
    'title'      => __('Social Media Links', 'acmfsap'),
    'id'         => 'social-media-section',
    'subsection' => false,
));

$fields_array = array();
$section_array = array("Facebook", "Twitter", "YouTube", "LinkedIn");

foreach ($section_array as $section) {
    Redux::setSection($opt_name, array(
        'title'      => __($section, 'acmfsap'),
        'id'         => 'footer-' . $section . '-section',
        'subsection' => true,

        'fields'     => array(
            array(
                'id'       => $section . '-icon',
                'type'     => 'text',
                'title'    => __($section . ' Icon/Logo', 'acmfsap'),
            ),
            array(
                'id'       => $section . '-url',
                'type'     => 'text',
                'title'    => __($section . ' Url', 'acmfsap'),
                'validate' => 'url',
            ),
        )
    ));
}

Redux::setSection($opt_name, array(
    'title'      => __('Footer', 'acmfsap'),
    'id'         => 'footer-section',
    'subsection' => false,
));
Redux::setSection($opt_name, array(
    'title'      => __('Footer Background', 'acmfsap'),
    'id'         => 'footer-bgrd-section',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'footer-bgrd-image',
            'type'     => 'media',
            'title'    => __('Footer Background Image', 'acmfsap'),
            'default'  => array(
                'url' => ''
            ),
        ),
        array(
            'id'       => 'footer-bgrd-position',
            'type'     => 'select',
            'title'    => __('Footer Background Position', 'acmfsap'),
            'options'  => array(
                'top'     => 'top',
                'center' => 'center',
                'bottom' => 'bottom',
            ),
            'default'  => 'top',
        ),

    ),
));
Redux::setSection($opt_name, array(
    'title'      => __('Information', 'acmfsap'),
    'id'         => 'info-section',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'about-title',
            'type'     => 'text',
            'title'    => __('About Title', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'about-info',
            'type'     => 'textarea',
            'title'    => __('About Info', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'about-btn-text',
            'type'     => 'text',
            'title'    => __('About Button Text', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'about-btn-link',
            'type'     => 'text',
            'title'    => __('About Button Link', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'block-1-title',
            'type'     => 'text',
            'title'    => __('Block 1 Title', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'block-2-title',
            'type'     => 'text',
            'title'    => __('Block 2 Title', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'block-3-title',
            'type'     => 'text',
            'title'    => __('Block 3 Title', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
    ),
));


Redux::setSection($opt_name, array(
    'title'      => __('Credit', 'acmfsap'),
    'id'         => 'credit-section',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'credit',
            'type'     => 'text',
            'title'    => __('Credit Information', 'acmfsap'),
            'desc'     => __('Credit the website developer', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'credit_link',
            'type'     => 'text',
            'title'    => __('Link website developer credited', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
    ),
));



Redux::setSection($opt_name, array(
    'title'      => __('Copyright', 'acmfsap'),
    'id'         => 'copyright-section',
    'subsection' => true,
    'fields' => array(
        array(
            'id'       => 'copyright',
            'type'     => 'text',
            'title'    => __('Copyright Information', 'acmfsap'),
            'desc'     => __('Enter the copyright information', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),
        array(
            'id'       => 'copyright_link',
            'type'     => 'text',
            'title'    => __('Link copyright owner', 'acmfsap'),
            'default'  => '',
            'args'   => array(
                'wpautop' => false,
            )
        ),

    ),
));
	

    /*
     * <--- END SECTIONS
     */