<?php

/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package acmfsap
 */

get_header();
?>

<main id="primary" class="site-main">

    <?php
    while (have_posts()) :
        the_post();

        //body
        $photo = get_the_post_thumbnail_url(get_the_ID(), "large");
        if (!$photo) {
            $photo = wp_get_attachment_image_url('7342', "large");
        }

        $ss_content = strip_tags(get_the_content());
        $ss_main_title = get_post_meta(get_the_ID(), '_acmfsap_secondary_section_main_title', true);
        $ss_sub_title = get_post_meta(get_the_ID(), '_acmfsap_secondary_section_sub_title', true);
        $ss_desc = wpautop(get_post_meta(get_the_ID(), '_acmfsap_secondary_section_desc', true));
        $ss_button_icon_1 = get_post_meta(get_the_ID(), '_acmfsap_home_button_icon_1', true);
        $ss_button_sub_title_1 = get_post_meta(get_the_ID(), '_acmfsap_home_button_sub_title_1', true);
        $ss_button_main_title_1 = get_post_meta(get_the_ID(), '_acmfsap_home_button_main_title_1', true);
        $ss_button_link_1 = get_post_meta(get_the_ID(), '_acmfsap_home_button_link_1', true);
        $ss_button_icon_2 = get_post_meta(get_the_ID(), '_acmfsap_home_button_icon_2', true);
        $ss_button_sub_title_2 = get_post_meta(get_the_ID(), '_acmfsap_home_button_sub_title_2', true);
        $ss_button_main_title_2 = get_post_meta(get_the_ID(), '_acmfsap_home_button_main_title_2', true);
        $ss_button_link_2 = get_post_meta(get_the_ID(), '_acmfsap_home_button_link_2', true);


        // Repeatable group
        $school = '';
        $ss_schools = get_post_meta(get_the_ID(), '_acmfsap_home_school', true);
        foreach ((array) $ss_schools as $key => $ss_school) {

            $school_name = $school_location = $school_logo = '';

            if (isset($ss_school['_acmfsap_home_school_name'])) {
                $school_name = esc_html($ss_school['_acmfsap_home_school_name']);
            }
            if (isset($ss_school['_acmfsap_home_school_location'])) {
                $school_location = esc_html($ss_school['_acmfsap_home_school_location']);
            }
            if (isset($ss_school['_acmfsap_home_school_logo'])) {
                $school_logo = wp_get_attachment_image_url($ss_school['_acmfsap_home_school_logo_id'], 'profile-photo');
            }

            $school .= '
            <!-- -------------
                school
            ------------------>
            <div class="col-sm-12 col-lg-3 d-flex align-items-stretch">
                <div class="card card-hover w-100">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-8 d-flex align-items-center">
                                <div>
                                    <span>' . $school_location . '</span>
                                    <h4 class="mb-0">' . $school_name . '</h4>
                                </div>
                            </div>
                            <div class="col-4 d-flex justify-content-end">
                                <img alt="' . $school_name . '" src="' . $school_logo . '">
                            </div>
                        </div>
                    </div>
                </div>
            </div>';
        }



    endwhile; // End of the loop.
    ?>

    <!-- -------------------------------------------------------------- --> <!-- -------------------------------------------------------------- -->
    <!-- Page wrapper  -->
    <!-- -------------------------------------------------------------- -->
    <div class="page-wrapper">
        <!-- -------------------------------------------------------------- -->
        <!-- Container fluid  -->
        <!-- -------------------------------------------------------------- -->
        <div class="container-fluid">
            <!-- -------------------------------------------------------------- -->
            <!-- Overview, Visits, Sales, Order -->
            <!-- -------------------------------------------------------------- -->
            <div class="row">
                <!-- column -->
                <div class="col-sm-12 col-lg-6 d-flex align-items-stretch">
                    <!-- ---------------------
                            start Last Month Summary
                        ---------------- -->
                    <div class="card w-100 welcome" style="background-image: url(<?php echo $photo; ?>); background-size: cover;">
                        <div class="card-body">
                            <div class="title-wrap mb-3">
                                <h1 class="fw-bold mb-0">Welcome</h1>
                                <span class="card-subtitle mb-0">to the ACMF Scholarship Application Portal</span>
                            </div>
                            <div class="content-wrap">
                                <p><?php echo $ss_content; ?></p>
                            </div>
                        </div>
                        <!-- <div class="mt-5">
                            <div class="overview-campaign"></div>
                        </div> -->
                    </div>
                    <!-- ---------------------
                            end Last Month Summary
                        ---------------- -->
                </div>
                <!-- column -->
                <div class="col-sm-12 col-lg-6 ">
                    <div class="row">
                        <!-- column -->
                        <div class="col-sm-12 d-flex align-items-stretch">
                            <!-- ---------------------
                                    start Order Status
                                ---------------- -->
                            <div class="card order-widget w-100">
                                <div class="card-body">
                                    <div class="row">
                                        <!-- column -->
                                        <div class="col-sm-12">
                                            <h4 class="card-title"><?php echo $ss_main_title; ?></h4>
                                            <h5 class="card-subtitle mb-0"><?php echo $ss_sub_title; ?></h5>
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <p><?php echo $ss_desc; ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- ---------------------
                                    end Order Status
                                ---------------- -->
                        </div>
                        <!-- column -->
                        <div class="col-sm-12 col-md-6 ">
                            <!-- ---------------------
                                    start Total Visits
                                ---------------- -->
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="me-2">
                                            <span class="text-primary display-5">
                                                <i class="<?php echo $ss_button_icon_1; ?>"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <?php echo $ss_button_sub_title_1; ?><br>
                                            <b><?php echo $ss_button_main_title_1; ?></b>
                                        </div>
                                    </div>
                                </div>
                                <div class="sales-ratio"></div>
                            </div>
                            <!-- ---------------------
                                    end Total Visits
                                ---------------- -->
                        </div>
                        <!-- column -->
                        <div class="col-sm-12 col-md-6 ">
                            <!-- ---------------------
                                    start Sales Ratio
                                ---------------- -->
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="me-2">
                                            <span class="text-orange display-5">
                                                <i class="<?php echo $ss_button_icon_2; ?>"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <?php echo $ss_button_sub_title_2; ?><br>
                                            <b><?php echo $ss_button_main_title_2; ?></b>
                                        </div>
                                    </div>
                                </div>
                                <div class="sales-ratio"></div>
                            </div>
                            <!-- ---------------------
                                    end Sales Ratio
                                ---------------- -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- -------------------------------------------------------------- -->
            <!-- Ravenue - page-view-bounce rate -->
            <!-- -------------------------------------------------------------- -->
            <div class="row">
                <?php echo $school; ?>
            </div>
        </div>
        <!-- -------------------------------------------------------------- -->
        <!-- End Container fluid  -->
        <!-- -------------------------------------------------------------- -->
    </div>

</main><!-- #main -->

<?php
get_footer();
